﻿using System;
using System.Security.Cryptography.X509Certificates;
using System.Text.RegularExpressions;
using HIPS.PcehrDataStore.Schemas;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using Test.CommonCcaNoc.Helpers;

namespace Test.PcehrCcaNoc.ClinicalDocuments
{
    /// <summary>
    /// Conformance Test Specification: Clinical Documents
    ///                                 Version 1.2 — 12 September 2012
    /// Use Case #:	    CPCD_Producer
    /// Use Case Name:	Produce a Discharge Summary clinical document
    /// Test Case ID:   CPCD_P_DS3133
    /// Objective:
    /// To check that Discharge Summary clinical documents are digitally
    /// signed by the authoring healthcare provider organisation using
    /// its digital credential. A digital signature is required as part
    /// of the CDA Package [NEHTA2011] and must conform to the
    /// requirements of the signed container profile [SA2010].
    /// </summary>
    [TestClass]
    public class CPCD_P_DS3133_1A : CcaTest
    {
        private CdaDocument cdaDocument;
        private CdaSignature cdaSignature;
        private ClinicalDocumentVersion version;

        /// <summary>
        /// Shared helper method to ensure that a document has been uploaded
        /// and get the CDA signature, CDA document and the package.
        /// The document will be reused between the tests in this class.
        /// </summary>
        private void UploadDocument()
        {
            SharedPackage shared = SharedPackage.GetSharedInstance1A(this, SampleDocumentType.DischargeSummary1A);
            this.cdaDocument = shared.CdaDocument;
            this.cdaSignature = shared.CdaSignature;
            this.version = shared.Version;
        }

        /// <summary>
        /// b. Verify the HPI-O of the authoring healthcare provider organisation
        ///    listed in the clinical document is identical to the HPI-O contained
        ///    within the digital certificate in the eSignature contained within
        ///    the CDA Package.
        ///
        /// Note: the HPI-O of the authoring healthcare provider organisation can
        /// be found within the CDA schema data element author/assignedAuthor/
        /// assignedPerson/asEmployment/employerOrganization/asOrganizationPartOf/
        /// wholeOrganization/asEntityIdentifier.
        ///
        /// Note: locating the HPI-O within the digital certificate requires
        /// knowledge of the structure of the digital certificate.
        /// </summary>
        [TestMethod]
        [TestCategory("CD_CCA_1A")]
        public void ClinicalDocuments_1A_CPCD_P_DS3133_B()
        {
            UploadDocument();

            string authorHpio = cdaDocument.GetAuthorOrganisationEntityIdentifier();

            string certBase64 = cdaSignature.GetX509CertificateElement().InnerText;
            byte[] certBytes = Convert.FromBase64String(certBase64);
            X509Certificate2 signingCert = new X509Certificate2(certBytes);
            Match match = Regex.Match(signingCert.SubjectName.Name,
                "(................).id.electronichealth.net.au");
            string certHpio = match.Groups[1].Value;

            LogAssert.AreEqual(authorHpio, certHpio,
                DialogueResource.AuthorOrganisationHpio,
                DialogueResource.SignatureCertificateHpio);
        }
    }
}